/****** Object:  Trigger [TRG_EST_NF_ENT_EST_NF_SAI_TRANSF_INCLUI_PENDENCIA]    Script Date: 01/17/2014 15:11:38 ******/
IF EXISTS(SELECT *
			FROM sys.triggers
				WHERE object_id = OBJECT_ID(N'[dbo].[TRG_EST_NF_ENT_EST_NF_SAI_TRANSF_INCLUI_PENDENCIA]')
)
    DROP TRIGGER [dbo].[TRG_EST_NF_ENT_EST_NF_SAI_TRANSF_INCLUI_PENDENCIA];
GO
GO
-----------------------------------DELETAR EM EST_NF_ENT_EST_NF_SAI_TRANSF-----------------------------------  
CREATE TRIGGER [dbo].[TRG_EST_NF_ENT_EST_NF_SAI_TRANSF_INCLUI_PENDENCIA] ON [dbo].[EST_NF_ENT_EST_NF_SAI_TRANSF]
FOR DELETE
AS
SET NOCOUNT ON;

     --Pendencia de entrada de nota fiscal de transferencia  
    INSERT INTO EST_NF_SAI_PENDENCIA(CD_EMP, CD_FILIAL, CD_NF, CD_FILIAL_DEST)
    SELECT DISTINCT 
            s.CD_EMP, 
            s.CD_FILIAL, 
            s.CD_NF, 
            s.CD_CLI
    FROM DELETED d
            INNER JOIN EST_NF_SAI s ON d.CD_FIL_ORIG = s.CD_FILIAL
                                    AND d.CD_EMP = s.CD_EMP
                                    AND d.CD_NF_SAI = s.CD_NF
    WHERE s.STS_NF = 0
            AND s.PEND_ENTRADA = 0  --NAO CANCELADA, PENDENTE DE ENTRADA  
            AND s.CD_NT_MOV IN ( SELECT CD_MOV_OP
								FROM GLB_MOV_OP
								WHERE DEST_ORIG = 2 --Apenas movimentacoes de filiais
								)
            AND NOT EXISTS(SELECT 1
							FROM EST_NF_SAI_PENDENCIA PEND
							WHERE CD_EMP = S.CD_EMP
									AND CD_FILIAL = S.CD_FILIAL
									AND CD_NF = S.CD_NF);
------------------------------------------------------------------------------------------------------------------------
     --PendEncia de entrada vendas grupo economico  
	INSERT INTO EST_NF_SAI_PENDENCIA(CD_EMP, CD_FILIAL, CD_NF, CD_FILIAL_DEST)
    SELECT DISTINCT 
            s.CD_EMP, 
            s.CD_FILIAL, 
            s.CD_NF, 
            r.CD_FILIAL
    FROM DELETED d
            INNER JOIN EST_NF_SAI s ON d.CD_FIL_ORIG = s.CD_FILIAL
                                    AND d.CD_EMP = s.CD_EMP
                                    AND d.CD_NF_SAI = s.CD_NF
            INNER JOIN PRC_FILIAL_RC_CLI r ON s.CD_EMP = r.CD_EMP
                                            AND s.CD_CLI = r.CD_CLI
    WHERE s.STS_NF = 0
            AND s.PEND_ENTRADA = 0 --transacao de saida, preco custo  
            AND CD_NT_MOV IN (SELECT CD_MOV_OP
								FROM GLB_MOV_OP
								WHERE
									TP_MOV_OP_TRANSA = 1
									AND DEST_ORIG=0	--Apenas movimentacoes de cliente 
									)
            AND NOT EXISTS	(SELECT 1 FROM 
											EST_NF_SAI_PENDENCIA PEND
									WHERE CD_EMP			    = S.CD_EMP
											AND CD_FILIAL		= S.CD_FILIAL
											AND CD_NF			= S.CD_NF
											AND CD_FILIAL_DEST	= R.CD_FILIAL);
------------------------------------------------------------------------------------------------------------------------
    --Pendente de entrada outras saidas para o grupo economico  
	INSERT INTO EST_NF_SAI_PENDENCIA  (CD_EMP, CD_FILIAL, CD_NF, CD_FILIAL_DEST)
	SELECT DISTINCT 
			s.CD_EMP, 
			s.CD_FILIAL AS CD_FILIAL_ORIG, 
			s.CD_NF, 
			f.CD_FILIAL AS CD_FILIAL_DEST
	FROM DELETED d
			INNER JOIN EST_NF_SAI s ON d.CD_FIL_ORIG = s.CD_FILIAL
									AND d.CD_EMP = s.CD_EMP
									AND d.CD_NF_SAI = s.CD_NF
			INNER JOIN PRC_FILIAL_PG_FORN f ON s.CD_EMP = f.CD_EMP
											AND s.CD_CLI = f.CD_FORN
	WHERE s.STS_NF = 0
			AND s.PEND_ENTRADA = 0                 --transacao de saida, preco custo  
			AND CD_NT_MOV IN
			(SELECT CD_MOV_OP
				FROM GLB_MOV_OP
				WHERE 
					TP_MOV_OP_TRANSA = 1
					AND DEST_ORIG=1 --Apenas movimentacoes de fornecedores 
					)
			AND NOT EXISTS
				(SELECT 1
					FROM EST_NF_SAI_PENDENCIA PEND
					WHERE CD_EMP = S.CD_EMP
						AND CD_FILIAL = S.CD_FILIAL
						AND CD_NF = S.CD_NF
						AND CD_FILIAL_DEST = F.CD_FILIAL); 
------------------------------------------------------------------------------------------------------------------------